/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Copy;

public class CopyTest
extends AbstractFilterTest {
    public CopyTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return this.getFilter("1-3");
    }

    public Filter getFilter(String rangelist) {
        try {
            Copy af = new Copy();
            af.setAttributeIndices(rangelist);
            return af;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            CopyTest.fail("Exception setting attribute range: " + rangelist + "\n" + ex.getMessage());
            return null;
        }
    }

    public void testTypical() {
        this.m_Filter = this.getFilter("1,2");
        Instances result = this.useFilter();
        int origNum = this.m_Instances.numAttributes();
        CopyTest.assertEquals(origNum + 2, result.numAttributes());
        CopyTest.assertTrue(result.attribute(origNum).name().endsWith(this.m_Instances.attribute(0).name()));
        CopyTest.assertTrue(result.attribute(origNum + 1).name().endsWith(this.m_Instances.attribute(1).name()));
    }

    public void testTypical2() {
        this.m_Filter = this.getFilter("3-4");
        Instances result = this.useFilter();
        int origNum = this.m_Instances.numAttributes();
        CopyTest.assertEquals(origNum + 2, result.numAttributes());
        CopyTest.assertTrue(result.attribute(origNum).name().endsWith(this.m_Instances.attribute(2).name()));
        CopyTest.assertTrue(result.attribute(origNum + 1).name().endsWith(this.m_Instances.attribute(3).name()));
    }

    public void testNonInverted() {
        this.m_Filter = this.getFilter("1,2");
        ((Copy)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        int origNum = this.m_Instances.numAttributes();
        CopyTest.assertEquals(origNum + origNum - 2, result.numAttributes());
        CopyTest.assertTrue(result.attribute(origNum).name().endsWith(this.m_Instances.attribute(2).name()));
        CopyTest.assertTrue(result.attribute(origNum + 1).name().endsWith(this.m_Instances.attribute(3).name()));
    }

    public void testNonInverted2() {
        this.m_Filter = this.getFilter("first-3");
        ((Copy)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        int origNum = this.m_Instances.numAttributes();
        CopyTest.assertEquals(origNum + origNum - 3, result.numAttributes());
        CopyTest.assertTrue(result.attribute(origNum).name().endsWith(this.m_Instances.attribute(3).name()));
    }

    public static Test suite() {
        return new TestSuite(CopyTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(CopyTest.suite());
    }
}

